/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;

final class CollectionOperationTypeAdapter
extends TypeAdapter<Collection> {
    private static final JsonElement EMPTY_ARRAY = new JsonArray();
    private final TypeAdapter<Collection> collectionTypeAdapter;

    public CollectionOperationTypeAdapter(TypeAdapter<Collection> collectionTypeAdapter) {
        this.collectionTypeAdapter = collectionTypeAdapter;
    }

    public void write(JsonWriter out, Collection value) throws IOException {
        this.collectionTypeAdapter.write(out, (Object)value);
    }

    public Collection read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.BEGIN_OBJECT) {
            Collection res = (Collection)this.collectionTypeAdapter.fromJsonTree(EMPTY_ARRAY);
            in.beginObject();
            while (in.hasNext()) {
                Operator op = Operator.valueOf(in.nextName());
                Collection operand = op == Operator.$clear ? null : (Collection)this.collectionTypeAdapter.read(in);
                op.apply(res, operand);
            }
            in.endObject();
            return res;
        }
        return (Collection)this.collectionTypeAdapter.read(in);
    }

    private static enum Operator {
        $add{

            @Override
            public void apply(Collection to, Collection from) {
                to.addAll(from);
            }
        }
        ,
        $remove{

            @Override
            public void apply(Collection to, Collection from) {
                to.removeAll(from);
            }
        }
        ,
        $clear{

            @Override
            public void apply(Collection to, Collection from) {
                to.clear();
            }
        };


        public abstract void apply(Collection var1, Collection var2);
    }
}

